/*
   ######################################################################

   XBlast Robot.inc

   Character design tutorial part 3

   (C) by Mark Weyer

   ######################################################################
*/

//
///
//// Our character does not really move so far. It just slides across the
//// floor. This is no surprise, as we have not designed it to move. Now
//// we will take care of movements. When this file is included in the
//// overall image creation process, some variables are set that determine
//// the state our character is in. For the moment we will only respect
//// the following three:
//// - playerStanding is a flag that is set if the character standing
////   still, waiting for orders. This is what we have assumed anyway,
////   so we will not change anything with respect to that.
//// - playerWalking is a flag that is set if the player is walking
////   from one position to the next. For this case we will alter the code.
//// - playerWalkingClock is set only if playerWalking is true.
////   It determines, which part of the process of walking the
////   character is currently in. Its value can be 0, 1, 2, or 3.
////   The sequence shown on screen when walking long distances is
////   ...0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3... . One cycle suffices to move
////   to the neighbouring position.
//// - playerWalkingTime is a rescaling of playerWalkingClock. Its value
////   should be thought of as continually ranging from 0 to 1 during
////   one cycle. Actually it only assumes the values 0, 0.25, 0.5, 0.75.
//// We will adjust the code so that the wheel makes a half revolution
//// (after which it looks the same again) during one animation cycle.
//// Also the eyes will move.
///
//

// colours

#local wheelColour1 = handsFeetColor;
#local wheelColour2 = armsLegsColor;
#local eyeColour = faceColor;

// basic constants

#declare Wheel_diam = 8/pi;
//
///
//// This new diameter makes the circumference 8 units,
//// so that with half a revolution the wheel travels 4 units (one position).
///
//
//#declare Wheel_diam = 2;
#declare Wheel_thickness = 1/2;
#declare Eye_size = 2/3;

// a macro for eyes

#macro eye(side)
  sphere {
    0 1/2
    pigment {	// this pigment partitions the eye into three layers:
		// black (pupil), eyeColour (iris), and white (rest)
      checker
      pigment {rgb <1,1,1>}
      pigment {
        checker
        pigment {rgb eyeColour}
        pigment {rgb <0,0,0>}
        translate <1/2,1/2,0>
        scale 10
        translate -z/4
      }
      translate <1/2,1/2,0>
      scale <10,10,1>
      translate -z/6
    }
//
///
//// This rotate is new. The eyes will look left and right during walking.
///
//
    #if (playerWalking)
      rotate 45*sin(playerWalkingTime*2*pi)*y
    #end
    scale Eye_size
    translate <side*2/3,Wheel_diam,-1/2>
  }
#end

#macro wheel()
  torus {
    (Wheel_diam-Wheel_thickness)/2 Wheel_thickness/2
    rotate 90*z
    pigment {	// this pigment partitions the wheel in four sectors
      checker
      pigment {rgb wheelColour1}
      pigment {rgb wheelColour2}
      translate x/2
      scale 10
    }
//
///
//// This rotate is new. The wheel will turn.
//// For a cyclic animation there will be a half revolution per cycle.
///
//
    #if (playerWalking)
      rotate -180*playerWalkingTime*x
    #end
    translate Wheel_diam/2*y
  }
#end

union {
  wheel()
  eye(1)
  eye(-1)

  rotate playerAngle*y
  translate playerLocation
  translate -2*z
}

